﻿
CREATE PROCEDURE [App].[NVCC_usp_GetXdwUser]
	-- @username is the network (AD) username/login of the user
	@username varchar(50)
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetXdwUser
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 2017-02-14
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get LCustomer and AD information about a user
--==================================================================================
--Uses: CDWWork.NDim.ActiveDirectoryAccount
--Uses: CDWWork.LCustomer.LCustomer
--Uses: CDWWork.Dim.Sta3n

BEGIN
	SELECT TOP 1
		UPPER(ada.SamAccountName) AS NetWorkName
		,ada.Surname AS LastName
		,ada.GivenName AS FirstName
		,lc.LCustomerID
		,AccountEmailAddress as Email
		,lc.UpdatedDate as DateAdded
		,lc.InferredSta3n
		,s.Sta3n AS ADLoginInferredSta3n
	FROM
		CDWWork.NDim.ActiveDirectoryAccount AS ada
		LEFT JOIN CDWWork.LCustomer.LCustomer AS lc
			ON ada.SamAccountName = lc.ADLogin
		LEFT JOIN CDWWork.Dim.Sta3n s
			ON s.SiteCode = SUBSTRING(UPPER(@username), 4, 3)
	WHERE SamAccountName = @username
	ORDER BY lc.UpdatedDate DESC
END

